﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        public static byte MXM_FAN_CHANNEL = 1;

        public static byte gFan1 = 0;

        private void CheckMxmFan()
        {
            byte num;
            byte mask;

            num = AecFanGetNum(gPtrAecInit);
            if (num > 0)
            {
                mask = 0;
                AecFanGetMask(gPtrAecInit, ref mask);
                if ((mask & 0x02) == 0x02)    //check fan channel 1 can use
                {
                    gFan1 = 1;    //can use

                    label55.Enabled = true;
                    label57.Enabled = true;
                }
                else
                {
                    gFan1 = 0;    //can't use

                    label55.Enabled = false;
                    label57.Enabled = false;
                }
            }
        }

        private void ShowMxmInformation()
        {
            byte res;
            Int16 t16;
            UInt16 rpm;
            float temp;

            if (gFan1 == 1)
            {
                //temperature
                t16 = 0;
                res = AecFanGetTemperature(gPtrAecInit, MXM_FAN_CHANNEL, ref t16);
                if (res != 0)
                {
                    MessageBox.Show("Get MXM Temperature Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    temp = 0;
                }
                else
                {
                    temp = t16 / 10;    //unit 0.1 C
                }

                if (temp >= 0)  //EC return -273.1 C when MXM unplug
                {
                    label55.Text = temp.ToString("0.0");
                }
                else
                {
                    label55.Text = "0";
                }

                //speed
                rpm = 0;
                res = AecFanGetRpm(gPtrAecInit, MXM_FAN_CHANNEL, ref rpm);
                if (res != 0)
                {
                    MessageBox.Show("Get Fan Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    rpm = 0;
                }

                label57.Text = rpm.ToString();
            }
        }
    }
}
